import React from 'react';
import { Link } from 'react-router-dom';
import AggressivePopups from '../../features/Popup';
import styles from './styles.module.css';

function Layout({ children }) {
  return (
    <div className={styles.container}>
      <nav className={styles.navbar}>
        <Link to="/" className={styles.navLink}>ホーム</Link>
        <Link to="/careers" className={styles.navLink}>採用情報</Link>
        <Link to="/company" className={styles.navLink}>会社情報</Link>
        <Link to="/blog" className={styles.navLink}>社員ブログ</Link>
        <Link to="/contact" className={styles.navLink}>お問い合わせ</Link>
      </nav>

      <main className={styles.main}>
        {children}
      </main>

      <AggressivePopups />
    </div>
  );
}

export default Layout; 