import React, { useState, useEffect } from 'react';
import { useNavigate } from 'react-router-dom';
import styles from './styles.module.css';
import { POPUP_MESSAGES } from '../../../constants/messages';

function AggressivePopups() {
  const [activePopups, setActivePopups] = useState([]);
  const navigate = useNavigate();

  // 一度だけポップアップを表示
  useEffect(() => {
    const hasShownPopup = sessionStorage.getItem('hasShownPopup');
    
    if (!hasShownPopup) {
      const id = Date.now();
      const message = POPUP_MESSAGES[Math.floor(Math.random() * POPUP_MESSAGES.length)];
      const position = {
        top: Math.random() * (window.innerHeight - 200),
        left: Math.random() * (window.innerWidth - 300)
      };

      const newPopup = { id, message, position };
      setActivePopups([newPopup]);
      
      // ポップアップ表示済みフラグを保存
      sessionStorage.setItem('hasShownPopup', 'true');

      // 5秒後に自動で消える
      setTimeout(() => {
        setActivePopups([]);
      }, 5000);
    }
  }, []);

  return (
    <>
      {activePopups.map(popup => (
        <div
          key={popup.id}
          className={styles.popup}
          style={{
            top: popup.position.top,
            left: popup.position.left
          }}
        >
          <div className={styles.popupTitle}>
            採用担当からのメッセージ！
            <button
              className={styles.closeButton}
              onClick={() => setActivePopups([])}
            >
              ×
            </button>
          </div>
          <div className={styles.popupContent}>
            {popup.message}
          </div>
          <div className={styles.popupButtons}>
            <button 
              className={styles.button}
              onClick={() => navigate('/careers')}
            >
              応募する！
            </button>
            <button 
              className={styles.button}
              onClick={() => setActivePopups([])}
            >
              また今度
            </button>
          </div>
        </div>
      ))}
    </>
  );
}

export default AggressivePopups; 