<?php
namespace App\Services\CsvStreamServices;

use App\Exceptions\EmptyCsvDownloadException;
use App\Exceptions\EncodingCsvDownloadException;
use Illuminate\Support\LazyCollection;

/**
 * 実装例：CSV情報
 * @author maeda
 */
class ExampleCsvStreamService extends AbstractCsvStreamService
{
    /**
     * ファイル名取得
     * @param void
     * @return String
     */
    protected function getFileName(): string
    {
        return 'example.csv';
    }

    /**
     * 項目名データ取得
     * @param void
     * @return Array
     */
    protected function getCsvHeader(): Array
    {
        return ['列1', '列2', '列3'];
    }

    /**
     * 項目データ取得
     * @param void
     * @return Array
     */
    protected function format($entity): Array
    {
        $row = [];

        $row[] = $entity->column1;
        $row[] = $entity->column2;
        $row[] = $entity->column3;

        return $row;
    }
}
