<?php

namespace App\Http\Controllers;

use App\Http\Requests\CreateQuestionnaireRequest;
use App\Http\Requests\UpdateQuestionnaireRequest;
use App\Http\Controllers\AppBaseController;
use App\Repositories\QuestionnaireRepository;
use Illuminate\Http\Request;
use Flash;

class QuestionnaireController extends AppBaseController
{
    /** @var QuestionnaireRepository $questionnaireRepository*/
    private $questionnaireRepository;

    public function __construct(QuestionnaireRepository $questionnaireRepo)
    {
        $this->questionnaireRepository = $questionnaireRepo;
    }

    /**
     * Display a listing of the Questionnaire.
     */
    public function index(Request $request)
    {
        $questionnaires = $this->questionnaireRepository->paginate(10);

        return view('questionnaires.index')
            ->with('questionnaires', $questionnaires);
    }

    /**
     * Show the form for creating a new Questionnaire.
     */
    public function create()
    {
        return view('questionnaires.create');
    }

    /**
     * Store a newly created Questionnaire in storage.
     */
    public function store(CreateQuestionnaireRequest $request)
    {
        $input = $request->all();

        $questionnaire = $this->questionnaireRepository->create($input);

        Flash::success('Questionnaire saved successfully.');

        return redirect(route('questionnaires.index'));
    }

    /**
     * Display the specified Questionnaire.
     */
    public function show($id)
    {
        $questionnaire = $this->questionnaireRepository->find($id);

        if (empty($questionnaire)) {
            Flash::error('Questionnaire not found');

            return redirect(route('questionnaires.index'));
        }

        return view('questionnaires.show')->with('questionnaire', $questionnaire);
    }

    /**
     * Show the form for editing the specified Questionnaire.
     */
    public function edit($id)
    {
        $questionnaire = $this->questionnaireRepository->find($id);

        if (empty($questionnaire)) {
            Flash::error('Questionnaire not found');

            return redirect(route('questionnaires.index'));
        }

        return view('questionnaires.edit')->with('questionnaire', $questionnaire);
    }

    /**
     * Update the specified Questionnaire in storage.
     */
    public function update($id, UpdateQuestionnaireRequest $request)
    {
        $questionnaire = $this->questionnaireRepository->find($id);

        if (empty($questionnaire)) {
            Flash::error('Questionnaire not found');

            return redirect(route('questionnaires.index'));
        }

        $questionnaire = $this->questionnaireRepository->update($request->all(), $id);

        Flash::success('Questionnaire updated successfully.');

        return redirect(route('questionnaires.index'));
    }

    /**
     * Remove the specified Questionnaire from storage.
     *
     * @throws \Exception
     */
    public function destroy($id)
    {
        $questionnaire = $this->questionnaireRepository->find($id);

        if (empty($questionnaire)) {
            Flash::error('Questionnaire not found');

            return redirect(route('questionnaires.index'));
        }

        $this->questionnaireRepository->delete($id);

        Flash::success('Questionnaire deleted successfully.');

        return redirect(route('questionnaires.index'));
    }
}
