<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Questionnaire extends Model
{
    public $table = 't_questionnaires';

    public $fillable = [
        'u_id',
        'q1',
        'q2',
        'q3',
        'q4',
        'q5',
        'q6'
    ];

    protected $casts = [
        'u_id' => 'integer',
        'q1' => 'string',
        'q2' => 'string',
        'q3' => 'string',
        'q4' => 'string',
        'q5' => 'string',
        'q6' => 'string'
    ];

    public static array $rules = [
        'u_id' => 'required|max:2',
        'q1' => 'required|max:32',
        'q2' => 'required|max:32',
        'q3' => 'required|max:100',
        'q4' => 'required|max:64',
        'q5' => 'required|max:64',
        'q6' => 'nullable'
    ];

    
}
