<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTQuestionnairesTable extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::create('t_questionnaires', function (Blueprint $table) {
            $table->bigIncrements('id')->comment('ID');
            $table->bigInteger('u_id')->unsigned()->length(20)->comment('ユーザーID');
            $table->string('q1', 32)->comment('設問1回答');
            $table->string('q2', 32)->comment('設問2回答');
            $table->string('q3', 100)->comment('設問3回答');
            $table->string('q4', 64)->comment('設問4回答');
            $table->string('q5', 64)->comment('設問5回答');
            $table->text('q6')->nullable()->comment('設問6回答');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down()
    {
        Schema::dropIfExists('t_questionnaires');
    }
};
